// DeleteCH.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteCH.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDeleteCH dialog


CDeleteCH::CDeleteCH(CWnd* pParent /*=NULL*/)
	: CDialog(CDeleteCH::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeleteCH)
	m_FirstName = _T("");
	m_LastName = _T("");
	m_DelCards = -1;
	m_DelImgs = -1;
	//}}AFX_DATA_INIT
}
CDeleteCH ::CDeleteCH(IApplication *pApp):CDialog(CDeleteCH::IDD, NULL)
{
	pApplication = pApp;
		
}
void CDeleteCH::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeleteCH)
	DDX_Control(pDX, IDC_DELIMGS, m_Btn_DelImgs);
	DDX_Control(pDX, IDC_DELCARDS, m_BtnDelCards);
	DDX_Control(pDX, IDC_LNAME, m_cnt_lname);
	DDX_Control(pDX, IDC_FNAME, m_cnt_Fname);
	DDX_Control(pDX, IDC_CHLIST, m_ChList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Text(pDX, IDC_FNAME, m_FirstName);
	DDX_Text(pDX, IDC_LNAME, m_LastName);
	DDX_Radio(pDX, IDC_DELCARDS, m_DelCards);
	DDX_Radio(pDX, IDC_DELIMGS, m_DelImgs);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDeleteCH, CDialog)
	//{{AFX_MSG_MAP(CDeleteCH)
	ON_BN_CLICKED(IDDEL, OnDelete)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_CBN_SELCHANGE(IDC_CHLIST, OnSelchangeChlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeleteCH message handlers
BOOL CDeleteCH::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_BtnDelCards.SetCheck(1);
	m_Btn_DelImgs.SetCheck(1);
	LoadAccounts(); // load account details in WP-CS system
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CDeleteCH :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CDeleteCH :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}

void CDeleteCH::LoadCardHolders()
{
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select Sub account name 
		BSTR bstrSubAcctName;
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}


		_variant_t vCHs;
		vCHs.Clear();
		pApplication->GetCardHoldersByAccountName(bstrAcctName, bstrSubAcctName, &vCHs); // get card holder details of particular account  in WP-CS database server
		
		if(vCHs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICardHolder *pCH = NULL;
		
		COleSafeArray sa(vCHs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
			if (pCH != NULL)
			{
				CString sCHid;
				sCHid.Format(L"%ld",pCH->CardHolderID);
				m_ChList.AddString(sCHid);
				pCH->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_ChList.SetCurSel(0);
}

void CDeleteCH ::GetCardHolderDetails()
{
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select Sub account name 
		BSTR bstrSubAcctName;
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}

		//select CHID
		int index_CH = m_ChList.GetCurSel();
		CString sCHid;
		m_ChList.GetLBText(index_CH,sCHid);
		long lCardHolderID = _wtoi(sCHid);

		// Getparticular card holder details
		_variant_t vCH;
		vCH.Clear();
		pApplication->GetCardHolderByCardHolderID(lCardHolderID,&vCH);
		
		if(vCH.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vCH.vt & VT_DISPATCH)
		{
			
			ICardHolderPtr pcardholder(vCH.pdispVal);
			m_FirstName =CString(((LPWSTR)pcardholder->FirstName));
			m_LastName =CString(((LPWSTR)pcardholder->LastName));
			pcardholder->AccountName = bstrAcctName;
			pcardholder->SubAccountName = bstrSubAcctName;
		}
		UpdateData(FALSE);
		//clear the Cardhodler object
		if(NULL != vCH.pdispVal)
		{
			//vCH.pdispVal->Release();
			vCH.Clear();
		}
}

void CDeleteCH::OnDelete() 
{
		//select CHID
		long lCardHolderID;
		int index_CH = m_ChList.GetCurSel();
		if (index_CH < 0)
			lCardHolderID = 0;
		else
		{
			CString sCHid;
			m_ChList.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);
		}
		//get the option for delete / detach the card;
		 if (m_BtnDelCards.GetCheck())
		 {
			 bDelCard = TRUE;
		 }
		 else
		 {
			 bDelCard = FALSE;
		 }

		//get the option for delete / detach image
		if (m_Btn_DelImgs.GetCheck())
		 {
			 bDelImage = TRUE;
		 }
		 else
		 {
			 bDelImage= FALSE;
		 }

		long lStatus;
		//delete the card holder;
		pApplication->DeleteCardHolder(lCardHolderID,bDelCard,bDelImage,&lStatus);

		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Card holder");
			return;
		}
		if ( lStatus == 1)
		{
			AfxMessageBox(L"Card holder Deletion Failed");
			return;
		}
		if (lStatus == 0)
		{
			AfxMessageBox(L"Card holder Deletion Succeded");
			CDialog::OnOK();
		}
	
}

void CDeleteCH::OnSelchangeAcctlist() 
{
	m_ChList.ResetContent();
	m_SubAcctList.ResetContent();
	LoadSubAccounts();
	m_cnt_Fname.SetWindowText(L"");
	m_cnt_lname.SetWindowText(L"");
	
}

void CDeleteCH::OnSelchangeSubAcctlist() 
{
	m_ChList.ResetContent();
	LoadCardHolders();
	m_cnt_Fname.SetWindowText(L"");
	m_cnt_lname.SetWindowText(L"");
	
}

void CDeleteCH::OnSelchangeChlist() 
{
	GetCardHolderDetails();	
	
}
